/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EditableTableDataModel;
import ibm.nways.jdm.eui.TableModelListener;
import java.io.Serializable;
import java.util.Vector;

public abstract class Table
implements EditableTableDataModel {
    protected Vector listeners = new Vector();
    protected Vector data = new Vector();
    protected Vector valid = new Vector();
    protected boolean startAtTop = true;
    protected boolean bottomKnown = false;
    protected ModelInfo topInfo;
    private boolean debug = false;

    public int getRowCount() {
        return this.data.size();
    }

    public Object getValueAt(Object object, int n) throws ArrayIndexOutOfBoundsException {
        if (this.debug) {
            System.out.println("getValueAt() invoked: row=" + n + " column=" + object);
        }
        Serializable serializable = null;
        ModelInfo modelInfo = (ModelInfo)this.elementAt(n);
        if (modelInfo != null) {
            serializable = modelInfo.get((String)object);
        }
        if (this.debug) {
            System.out.println("getValueAt() returns " + serializable);
        }
        return serializable;
    }

    public void setValueAt(Object object, Object object2, int n) {
        try {
            ModelInfo modelInfo = (ModelInfo)this.data.elementAt(n);
            modelInfo.add((String)object2, (Serializable)object);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(arrayIndexOutOfBoundsException);
            arrayIndexOutOfBoundsException.printStackTrace();
            return;
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        if (tableModelListener != null && !this.listeners.contains(tableModelListener)) {
            this.listeners.addElement(tableModelListener);
        }
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        if (tableModelListener != null && this.listeners.contains(tableModelListener)) {
            this.listeners.removeElement(tableModelListener);
        }
    }

    public boolean knownTop() {
        return this.startAtTop;
    }

    public boolean knownBottom() {
        return this.bottomKnown;
    }

    public void setTopRow(ModelInfo modelInfo) {
        ModelInfo modelInfo2 = null;
        if (modelInfo == null) {
            if (!this.startAtTop) {
                this.removeAllElements();
                this.topInfo = modelInfo;
                this.startAtTop = true;
                return;
            }
        } else {
            this.removeAllElements();
            this.topInfo = modelInfo;
            this.startAtTop = false;
            modelInfo2 = this.getSpecificRow(modelInfo);
            this.addElement(modelInfo2);
        }
    }

    public boolean isMonitored(int n) {
        boolean bl = false;
        ModelInfo modelInfo = (ModelInfo)this.elementAt(n);
        if (modelInfo != null) {
            bl = modelInfo.isBeingMonitored();
        }
        return bl;
    }

    public void setMonitoring(int n, boolean bl) {
        if (n >= 0) {
            ModelInfo modelInfo = (ModelInfo)this.elementAt(n);
            if (modelInfo != null) {
                if (bl) {
                    modelInfo.flagAsMonitored();
                } else {
                    modelInfo.flagAsNotMonitored();
                }
                this.data.setElementAt(modelInfo, n);
                ModelInfo[] modelInfoArray = new ModelInfo[]{modelInfo};
                if (!modelInfo.timeoutDetected) {
                    this.setMonitoring(modelInfoArray, bl);
                    return;
                }
            }
        } else {
            int n2 = 0;
            while (n2 < this.data.size()) {
                ModelInfo modelInfo = (ModelInfo)this.elementAt(n2);
                if (modelInfo != null) {
                    if (bl) {
                        modelInfo.flagAsMonitored();
                    } else {
                        modelInfo.flagAsNotMonitored();
                    }
                    this.data.setElementAt(modelInfo, n2);
                }
                ++n2;
            }
            this.setMonitoring(null, bl);
        }
    }

    public abstract void setMonitoring(ModelInfo[] var1, boolean var2);

    public synchronized void addElement(Object object) {
        this.data.addElement(object);
        this.valid.addElement(new Boolean(true));
    }

    public synchronized void insertElementAt(Object object, int n) {
    }

    public synchronized void removeAllElements() {
        this.data.removeAllElements();
        this.valid.removeAllElements();
        this.bottomKnown = false;
    }

    public synchronized boolean removeElement(Object object) {
        return true;
    }

    public synchronized void removeElementAt(int n) {
    }

    public synchronized void setElementAt(Object object, int n) {
        this.data.setElementAt(object, n);
        this.valid.setElementAt(new Boolean(true), n);
    }

    public int size() {
        return this.data.size();
    }

    public Object elementAt(int n) {
        if (this.debug) {
            System.out.println("elementAt() called for row " + n);
        }
        if (this.debug) {
            System.out.println("size of data vector is now " + this.data.size());
        }
        if (this.debug) {
            System.out.println("Index=" + n + " Size=" + this.data.size());
        }
        ModelInfo modelInfo = null;
        ModelInfo modelInfo2 = null;
        if (n < 0) {
            n = 0;
        }
        if (n < this.data.size()) {
            modelInfo = (ModelInfo)this.data.elementAt(n);
            if (this.debug) {
                System.out.println("Row " + n + " is valid = " + this.valid.elementAt(n));
            }
            if (!((Boolean)this.valid.elementAt(n)).booleanValue()) {
                if (this.debug) {
                    System.out.println("Recovering invalidated entry at index " + n);
                }
                if (this.debug) {
                    System.out.println("Retrieving row " + n + " from server");
                }
                if (this.debug) {
                    System.out.println("Input to server: " + modelInfo);
                }
                if (n == 0 && this.topInfo != null) {
                    modelInfo = this.getSpecificRow(modelInfo);
                } else if (n == 0) {
                    modelInfo = this.getRow(null);
                } else {
                    ModelInfo modelInfo3 = (ModelInfo)this.data.elementAt(n - 1);
                    modelInfo = this.getRow(modelInfo3);
                }
                if (this.debug) {
                    System.out.println("Response from server: " + modelInfo);
                }
                this.setElementAt(modelInfo, n);
                if (this.debug) {
                    System.out.println("Replaced element at " + n + " in vector");
                }
            }
        } else {
            if (!this.bottomKnown) {
                modelInfo2 = this.data.size() == 0 ? null : (ModelInfo)this.data.elementAt(this.data.size() - 1);
                while (n >= this.data.size()) {
                    if (this.debug) {
                        System.out.println("Retrieving row " + this.data.size() + " from server");
                    }
                    if (this.debug) {
                        System.out.println("Input to server: " + modelInfo2);
                    }
                    if ((modelInfo2 = this.getRow(modelInfo2)) == null) {
                        if (this.debug) {
                            System.out.println("Setting bottomKnown to true ...");
                        }
                        this.bottomKnown = true;
                        break;
                    }
                    if (!modelInfo2.timeoutDetected) {
                        if (this.debug) {
                            System.out.println("Response from server: " + modelInfo2);
                        }
                        this.data.addElement(modelInfo2);
                        this.valid.addElement(new Boolean(true));
                        continue;
                    }
                    if (this.debug) {
                        System.out.println("Response from server: " + modelInfo2);
                    }
                    this.data.addElement(modelInfo2);
                    this.valid.addElement(new Boolean(true));
                    if (this.debug) {
                        System.out.println("Setting bottomKnown to true ...");
                    }
                    this.bottomKnown = true;
                    break;
                }
            }
            modelInfo = modelInfo2;
        }
        if (this.debug) {
            System.out.println("elementAt() returns " + modelInfo);
        }
        return modelInfo;
    }

    public void invalidate() {
        int n = 0;
        while (n < this.valid.size()) {
            this.valid.setElementAt(new Boolean(false), n);
            ++n;
        }
        this.bottomKnown = false;
    }

    public ModelInfo getRow(ModelInfo modelInfo) {
        System.out.println("Warning: Default Table::getRow() called ...");
        return null;
    }

    public ModelInfo getSpecificRow(ModelInfo modelInfo) {
        System.out.println("Warning: Default Table::getSpecificRow() called ...");
        return null;
    }

    public ModelInfo setRow(ModelInfo modelInfo) {
        System.out.println("Warning: Default Table::setRow() called ...");
        return null;
    }

    public String translateEnum(String string, int n) {
        System.out.println("Warning: Table::translateEnum() called ...");
        return "no translation";
    }
}

